/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.Bounce;
import com.nokia.mid.appl.boun.BounceCanvas;
import com.nokia.mid.appl.boun.Local;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class BounceUI
implements CommandListener {
    public Bounce mMidlet;
    public Display mDisplay;
    public BounceCanvas mCanvas;
    public int mState = 2;
    public int mBestLevel;
    public int mBestScore;
    public boolean mNewBestScore;
    public int mLastScore;
    public byte mSavedValid;
    public byte mSavedLives;
    public byte mSavedRings;
    public byte mSavedLevel;
    public byte mSavedSize;
    public int mSavedScore;
    public int mSavedTileX;
    public int mSavedTileY;
    public int mSavedGlobalBallX;
    public int mSavedGlobalBallY;
    public int mSavedXSpeed;
    public int mSavedYSpeed;
    public int mSavedXPos;
    public int mSavedYPos;
    public int mSavedRespawnX;
    public int mSavedRespawnY;
    public int mSavedSpeedBonus;
    public int mSavedGravBonus;
    public int mSavedJumpBonus;
    public int mSavedTileCount;
    public int[][] mSavedTiles;
    private Command mOkayCmd;
    private Command mBackCmd;
    private Command mContinueCmd;
    private List mMainMenu;
    private List mNewGameMenu;
    private Form mTextPage;
    private int mSavedMenuItem;
    private static int MAIN_MENU_CONTINUE = 0;
    private static int MAIN_MENU_NEW_GAME = 1;
    private static int MAIN_MENU_HIGH_SCORE = 2;
    private static int MAIN_MENU_INSTRUCTIONS = 3;
    private static int MAIN_MENU_COUNT = 4;
    private String[] mMainMenuItems = new String[MAIN_MENU_COUNT];

    public BounceUI(Bounce bounce) {
        this.mMidlet = bounce;
        this.loadGameData();
        this.mCanvas = new BounceCanvas(this, 1);
        this.mCanvas.start();
        this.mDisplay = Display.getDisplay((MIDlet)this.mMidlet);
        this.mDisplay.setCurrent((Displayable)this.mCanvas);
        this.mMainMenuItems[BounceUI.MAIN_MENU_CONTINUE] = Local.getText(8);
        this.mMainMenuItems[BounceUI.MAIN_MENU_NEW_GAME] = Local.getText(16);
        this.mMainMenuItems[BounceUI.MAIN_MENU_HIGH_SCORE] = Local.getText(12);
        this.mMainMenuItems[BounceUI.MAIN_MENU_INSTRUCTIONS] = Local.getText(13);
    }

    public void displayMainMenu() {
        this.mMainMenu = new List(Local.getText(10), 3);
        if (this.mBackCmd == null) {
            this.mBackCmd = new Command(Local.getText(6), 2, 1);
        }
        if (this.mState == 1 || this.mSavedValid == -6) {
            this.mMainMenu.append(this.mMainMenuItems[0], null);
        }
        int n = 1;
        while (n < this.mMainMenuItems.length) {
            this.mMainMenu.append(this.mMainMenuItems[n], null);
            ++n;
        }
        this.mMainMenu.addCommand(this.mBackCmd);
        this.mMainMenu.setCommandListener((CommandListener)this);
        if (this.mCanvas.mSplashIndex != -1) {
            this.mCanvas.mSplashIndex = -1;
            this.mCanvas.mSplashImage = null;
        }
        this.mMainMenu.setSelectedIndex(this.mSavedMenuItem, true);
        this.mCanvas.stop();
        this.mDisplay.setCurrent((Displayable)this.mMainMenu);
    }

    public void displayNewGameMenu() {
        String[] stringArray = new String[this.mBestLevel];
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < this.mBestLevel) {
            stringArray2[0] = String.valueOf(n + 1);
            stringArray[n] = Local.getText(14, stringArray2);
            ++n;
        }
        this.mNewGameMenu = new List(Local.getText(16), 3, stringArray, null);
        this.mNewGameMenu.addCommand(this.mBackCmd);
        this.mNewGameMenu.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mNewGameMenu);
    }

    public void displayGame(boolean bl, int n) {
        this.mDisplay.setCurrent((Displayable)this.mCanvas);
        if (bl) {
            this.mCanvas.resetGame(n);
        }
        this.mCanvas.start();
        this.mState = 1;
    }

    public void displayHighScore() {
        this.mTextPage = new Form(Local.getText(12));
        this.mTextPage.append(String.valueOf(this.mBestScore));
        this.mTextPage.addCommand(this.mBackCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
    }

    public void displayInstructions() {
        this.mTextPage = new Form(Local.getText(13));
        this.mTextPage.append(Local.getText(0));
        this.mTextPage.append(Local.getText(1));
        this.mTextPage.append(Local.getText(2));
        this.mTextPage.append(Local.getText(3));
        this.mTextPage.append(Local.getText(4));
        this.mTextPage.append(Local.getText(5));
        this.mTextPage.addCommand(this.mBackCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
        this.mTextPage = null;
    }

    public void displayGameOver() {
        this.mCanvas.stop();
        if (this.mOkayCmd == null) {
            this.mOkayCmd = new Command(Local.getText(19), 4, 1);
        }
        this.mTextPage = new Form(Local.getText(11));
        this.mTextPage.append(Local.getText(11));
        this.mTextPage.append("\n\n");
        if (this.mNewBestScore) {
            this.mTextPage.append(Local.getText(17));
            this.mTextPage.append("\n\n");
        }
        this.mTextPage.append(String.valueOf(this.mLastScore));
        this.mTextPage.addCommand(this.mOkayCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
        this.mTextPage = null;
    }

    public void displayLevelComplete() {
        this.mCanvas.stop();
        if (this.mContinueCmd == null) {
            this.mContinueCmd = new Command(Local.getText(8), 4, 1);
        }
        this.mTextPage = new Form("");
        this.mTextPage.append(this.mCanvas.mLevelCompletedStr);
        this.mTextPage.append("\n\n");
        this.mTextPage.append("" + this.mLastScore + "\n");
        this.mTextPage.addCommand(this.mContinueCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
        this.mTextPage = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            if (displayable == this.mNewGameMenu) {
                this.displayGame(true, this.mNewGameMenu.getSelectedIndex() + 1);
            } else {
                String string = this.mMainMenu.getString(this.mMainMenu.getSelectedIndex());
                this.mSavedMenuItem = this.mMainMenu.getSelectedIndex();
                if (string.equals(this.mMainMenuItems[MAIN_MENU_CONTINUE])) {
                    if (this.mState == 1) {
                        this.displayGame(false, this.mCanvas.mLevelNum);
                    } else if (this.mSavedValid == -6) {
                        this.mDisplay.setCurrent((Displayable)this.mCanvas);
                        this.mCanvas.resetGame(this.mSavedGlobalBallX + (this.mSavedSize >> 1), this.mSavedGlobalBallY + (this.mSavedSize >> 1));
                        this.mSavedTiles = null;
                        this.mCanvas.start();
                        this.mState = 1;
                    }
                } else if (string.equals(this.mMainMenuItems[MAIN_MENU_NEW_GAME])) {
                    if (this.mState != 4) {
                        if (this.mBestLevel > 1) {
                            this.displayNewGameMenu();
                        } else {
                            this.mState = 4;
                            this.mNewBestScore = false;
                            this.displayGame(true, 1);
                        }
                    }
                } else if (string.equals(this.mMainMenuItems[MAIN_MENU_HIGH_SCORE])) {
                    this.displayHighScore();
                } else if (string.equals(this.mMainMenuItems[MAIN_MENU_INSTRUCTIONS])) {
                    this.displayInstructions();
                }
            }
        } else if (command == this.mBackCmd || command == this.mOkayCmd) {
            if (this.mDisplay.getCurrent() == this.mMainMenu) {
                this.mMidlet.destroyApp(true);
                this.mMidlet.notifyDestroyed();
            } else {
                this.displayMainMenu();
            }
        } else if (command == this.mContinueCmd) {
            this.displayGame(false, 0);
        }
    }

    public void loadGameData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[255];
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"bounceRMS", (boolean)true);
            if (recordStore.getNumRecords() != 3) {
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray2, 0, byArray2.length);
                recordStore.addRecord(byArray3, 0, byArray3.length);
            } else {
                byArray = recordStore.getRecord(1);
                byArray2 = recordStore.getRecord(2);
                byArray3 = recordStore.getRecord(3);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.mBestLevel = dataInputStream.readByte();
                byteArrayInputStream = new ByteArrayInputStream(byArray2);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                this.mBestScore = dataInputStream.readInt();
                byteArrayInputStream = new ByteArrayInputStream(byArray3);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                this.mSavedValid = dataInputStream.readByte();
                this.mSavedLives = dataInputStream.readByte();
                this.mSavedRings = dataInputStream.readByte();
                this.mSavedLevel = dataInputStream.readByte();
                this.mSavedSize = dataInputStream.readByte();
                this.mSavedScore = dataInputStream.readInt();
                this.mSavedTileX = dataInputStream.readInt();
                this.mSavedTileY = dataInputStream.readInt();
                this.mSavedGlobalBallX = dataInputStream.readInt();
                this.mSavedGlobalBallY = dataInputStream.readInt();
                this.mSavedXSpeed = dataInputStream.readInt();
                this.mSavedYSpeed = dataInputStream.readInt();
                this.mSavedXPos = dataInputStream.readInt();
                this.mSavedYPos = dataInputStream.readInt();
                this.mSavedRespawnX = dataInputStream.readInt();
                this.mSavedRespawnY = dataInputStream.readInt();
                this.mSavedSpeedBonus = dataInputStream.readInt();
                this.mSavedGravBonus = dataInputStream.readInt();
                this.mSavedJumpBonus = dataInputStream.readInt();
                this.mSavedTileCount = dataInputStream.readByte();
                this.mSavedTiles = new int[this.mSavedTileCount][3];
                int n = 0;
                while (n < this.mSavedTileCount) {
                    this.mSavedTiles[n][0] = dataInputStream.readShort();
                    this.mSavedTiles[n][1] = dataInputStream.readShort();
                    this.mSavedTiles[n][2] = dataInputStream.readByte();
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveGameData(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            switch (n) {
                case 1: {
                    dataOutputStream.writeByte(this.mBestLevel);
                    break;
                }
                case 2: {
                    dataOutputStream.writeInt(this.mBestScore);
                    break;
                }
                case 3: {
                    int n2;
                    dataOutputStream.writeByte(-6);
                    dataOutputStream.writeByte(this.mCanvas.numLives);
                    dataOutputStream.writeByte(this.mCanvas.numRings);
                    dataOutputStream.writeByte(this.mCanvas.mLevelNum);
                    dataOutputStream.writeByte(this.mCanvas.mBall.mBallSize);
                    dataOutputStream.writeInt(this.mCanvas.mScore);
                    dataOutputStream.writeInt(this.mCanvas.tileX);
                    dataOutputStream.writeInt(this.mCanvas.tileY);
                    dataOutputStream.writeInt(this.mCanvas.mBall.globalBallX);
                    dataOutputStream.writeInt(this.mCanvas.mBall.globalBallY);
                    dataOutputStream.writeInt(this.mCanvas.mBall.xSpeed);
                    dataOutputStream.writeInt(this.mCanvas.mBall.ySpeed);
                    dataOutputStream.writeInt(this.mCanvas.mBall.xPos);
                    dataOutputStream.writeInt(this.mCanvas.mBall.yPos);
                    dataOutputStream.writeInt(this.mCanvas.mBall.respawnX);
                    dataOutputStream.writeInt(this.mCanvas.mBall.respawnY);
                    dataOutputStream.writeInt(this.mCanvas.mBall.speedBonusCntr);
                    dataOutputStream.writeInt(this.mCanvas.mBall.gravBonusCntr);
                    dataOutputStream.writeInt(this.mCanvas.mBall.jumpBonusCntr);
                    int[][] nArray = new int[40][3];
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < this.mCanvas.mTileMapHeight) {
                        n2 = 0;
                        while (n2 < this.mCanvas.mTileMapWidth) {
                            byte by = (byte)(this.mCanvas.tileMap[n4][n2] & 0xFF7F & 0xFFFFFFBF);
                            if (by == 7 || by == 29 || by == 13 || by == 14 || by == 21 || by == 22 || by == 15 || by == 16 || by == 23 || by == 24) {
                                nArray[n3][0] = n4;
                                nArray[n3][1] = n2;
                                nArray[n3][2] = by;
                                ++n3;
                            }
                            ++n2;
                        }
                        ++n4;
                    }
                    dataOutputStream.writeByte(n3);
                    n2 = 0;
                    while (n2 < n3) {
                        dataOutputStream.writeShort(nArray[n2][0]);
                        dataOutputStream.writeShort(nArray[n2][1]);
                        dataOutputStream.writeByte(nArray[n2][2]);
                        ++n2;
                    }
                    nArray = null;
                }
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"bounceRMS", (boolean)true);
            recordStore.setRecord(n, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void gameOver() {
        this.mState = 3;
        this.mSavedValid = (byte)-16;
        this.displayGameOver();
    }
}

