/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class Cuerdas
extends Canvas
implements Runnable {
    private static final int MAX_PUNTOS = 10;
    private int volumen;
    private int instrumento;
    private int numBarrasAcordes;
    private int numTrastes;
    private int traste;
    private int acorde;
    private int zoom;
    private Punto[] puntos;
    private Cuerda[] cuerdas;
    private String[] descTrastes;
    private Guitarra guitarra;
    private Player p;
    private MIDIControl mc;
    private int margenX;
    private int lB;
    private int lA;
    private int lP;
    private int lT;
    private int iO;
    private int lO;
    private boolean activo;
    private boolean acordeModificado;
    private boolean repintarBarra;
    private boolean repintarAcordes;

    public Cuerdas(Guitarra guitarra) throws Exception {
        this.guitarra = guitarra;
        this.setFullScreenMode(true);
        if (!this.hasPointerEvents()) {
            throw new Exception(Idioma.texto_error_tactil[guitarra.getIdioma()]);
        }
        this.p = Manager.createPlayer((String)"device://midi");
        this.p.realize();
        this.puntos = new Punto[10];
        int i = 0;
        while (i < this.puntos.length) {
            this.puntos[i] = new Punto();
            ++i;
        }
        this.cuerdas = new Cuerda[]{new Cuerda(52), new Cuerda(57), new Cuerda(62), new Cuerda(67), new Cuerda(71), new Cuerda(76)};
        this.descTrastes = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX"};
        this.volumen = 4;
        this.instrumento = 0;
        this.numTrastes = 5;
        this.traste = 1;
        this.acorde = -1;
        this.lB = 60;
        this.lA = 46;
        this.setZoom(0);
        this.setBarrasAcordes(1);
    }

    public int getWidth() {
        return 360;
    }

    public int getHeight() {
        return 640;
    }

    public int getVolumen() {
        return this.volumen;
    }

    public void setVolumen(int volumen) {
        this.volumen = volumen;
    }

    public int getInstrumento() {
        return this.instrumento;
    }

    public void setInstrumento(int instrumento) {
        this.instrumento = instrumento;
    }

    private void setTraste(int traste) {
        if (traste > 0 && traste <= this.descTrastes.length - this.numTrastes + 1) {
            this.traste = traste;
        }
    }

    private void setTrastes() {
        int min = 0;
        int max = 0;
        int i = 0;
        while (i < this.cuerdas.length) {
            this.cuerdas[i].setTraste(this.acorde > -1 ? this.guitarra.getAcordes()[this.acorde].getTraste(i) : 0);
            if ((min == 0 || this.cuerdas[i].getTraste() < min) && this.cuerdas[i].getTraste() > 0) {
                min = this.cuerdas[i].getTraste();
            }
            if (this.cuerdas[i].getTraste() > max) {
                max = this.cuerdas[i].getTraste();
            }
            ++i;
        }
        if (max > 0) {
            if (max - min >= this.numTrastes) {
                this.setTraste(min);
            } else {
                this.setTraste(max - this.numTrastes > 0 ? max - (this.numTrastes - 1) : 1);
            }
        }
    }

    protected int[] getTrastes() {
        int[] trastes = new int[this.cuerdas.length];
        int i = 0;
        while (i < this.cuerdas.length) {
            trastes[i] = this.cuerdas[i].getTraste();
            ++i;
        }
        return trastes;
    }

    protected int getAcorde() {
        return this.acorde;
    }

    protected void setAcorde(Acorde acorde) {
        this.guitarra.getAcordes()[this.acorde] = acorde;
        this.setTrastes();
    }

    protected int getBarrasAcordes() {
        return this.numBarrasAcordes;
    }

    protected void setBarrasAcordes(int numBarrasAcordes) {
        this.numBarrasAcordes = numBarrasAcordes;
        this.iO = this.lB + this.lA * numBarrasAcordes + this.lP + 22;
        this.repintarAcordes = true;
    }

    protected int getZoom() {
        return this.zoom;
    }

    protected void setZoom(int zoom) {
        this.zoom = zoom;
        this.margenX = zoom == 0 ? 80 : 40;
        this.lP = zoom == 0 ? 34 : 40;
        this.lT = zoom == 0 ? 39 : 47;
        this.iO = this.lB + this.lA * this.numBarrasAcordes + this.lP + Imagenes.imgUp.getHeight();
        this.lO = (this.numTrastes - 1) * this.lT - Imagenes.imgUp.getHeight() - 1;
    }

    private void activarCuerda(Cuerda cuerda) {
        this.mc.shortMidiEvent(144, cuerda.getNota(), this.volumen * 127 / 10);
        cuerda.activa(true);
    }

    private void desactivarCuerda(Cuerda cuerda, boolean silenciar) {
        if (silenciar) {
            this.mc.shortMidiEvent(144, cuerda.getNota(), 0);
        }
        cuerda.activa(false);
    }

    private void desactivarCuerdas() {
        int i = 0;
        while (i < this.cuerdas.length) {
            if (this.guitarra.getInstrumento(this.instrumento).silenciarNota()) {
                this.mc.shortMidiEvent(144, this.cuerdas[i].getNota(), 0);
            }
            this.cuerdas[i].activa(false);
            ++i;
        }
    }

    private boolean limpiarCuerdas() {
        boolean limpiarCuerdas = false;
        int i = 0;
        while (i < this.cuerdas.length) {
            if (this.cuerdas[i].getTraste() != 0) {
                limpiarCuerdas = true;
                break;
            }
            ++i;
        }
        return limpiarCuerdas;
    }

    public void paint(Graphics g) {
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        if (this.repintarBarra) {
            this.repintarBarra = false;
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.lB);
            g.drawImage(Imagenes.imgVolumen, 0, 0, 20);
            g.drawImage(Imagenes.imgSalir, this.getWidth(), 0, 24);
            g.drawImage(Imagenes.imgAjustes, this.getWidth() - this.lB, 0, 24);
            g.drawImage(Imagenes.imgZoom, this.getWidth() - 2 * this.lB, 0, 24);
            g.drawImage(Imagenes.imgBorrar, this.getWidth() - 3 * this.lB, 0, 24);
            if (!this.limpiarCuerdas()) {
                g.drawImage(Imagenes.imgSombra, this.getWidth() - 3 * this.lB, 0, 24);
            }
            g.drawImage(Imagenes.imgGrabar, this.getWidth() - 4 * this.lB, 0, 24);
            if (!this.guitarra.grabarAcorde()) {
                g.drawImage(Imagenes.imgSombra, this.getWidth() - 4 * this.lB, 0, 24);
            }
            g.fillRect(20, 10, 20, (10 - this.volumen) * 5);
        }
        if (this.repintarAcordes) {
            this.repintarAcordes = false;
            g.setColor(0, 0, 0);
            g.fillRect(0, this.lB, this.getWidth(), this.lA * this.numBarrasAcordes);
            g.setColor(255, 255, 255);
            int j = 0;
            while (j < this.numBarrasAcordes) {
                int i = 0;
                while (i < 6) {
                    g.setClip(i * this.lB, this.lB + j * this.lA, this.lB, this.lA);
                    g.drawImage(this.acorde == j * 6 + i ? (this.acordeModificado ? Imagenes.imgAcorde_h : Imagenes.imgAcorde_s) : Imagenes.imgAcorde, i * this.lB, this.lB + j * this.lA, 20);
                    g.drawString(this.guitarra.getAcordes()[j * 6 + i].getNombre(this.guitarra.getNotacion()), i * this.lB + this.lB / 2, this.lB + j * this.lA + 3 * this.lA / 4, 65);
                    ++i;
                }
                ++j;
            }
            g.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        g.drawImage(Imagenes.imgGuitarra[this.zoom][this.instrumento * 2 + this.guitarra.getSkin()], 0, this.lB + this.lA * this.numBarrasAcordes, 20);
        g.setColor(255, 255, 255);
        int i = 0;
        while (i < 5) {
            g.drawString(this.descTrastes[i + this.traste - 1], this.margenX - 12 + this.zoom * 10, this.lB + this.lA * this.numBarrasAcordes + this.lP + i * this.lT, 24);
            ++i;
        }
        g.drawImage(Imagenes.imgUp, this.getWidth() - this.margenX + 10 - this.zoom * 6, this.lB + this.lA * this.numBarrasAcordes + this.lP, 20);
        g.drawImage(Imagenes.imgDown, this.getWidth() - this.margenX + 10 - this.zoom * 6, this.lB + this.lA * this.numBarrasAcordes + this.lP + this.lT * (this.numTrastes - 1) - 1, 20);
        g.drawImage(Imagenes.imgOffset, this.getWidth() - this.margenX + 11 - this.zoom * 6, this.iO + 4 + (this.traste - 1) * (this.lO - 48) / (this.descTrastes.length - this.numTrastes), 20);
        boolean pintarAros = false;
        int cejilla = this.descTrastes.length;
        int i2 = 0;
        while (i2 < this.cuerdas.length) {
            if (this.cuerdas[i2].getTraste() > 0) {
                pintarAros = true;
                if (cejilla > -1 && this.cuerdas[i2].getTraste() < cejilla) {
                    cejilla = this.cuerdas[i2].getTraste();
                }
            } else {
                cejilla = -1;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.cuerdas.length) {
            if (i2 < 3 || this.instrumento > 0) {
                g.setColor(240, 240, 240);
            } else {
                g.setColor(160, 160, 160);
            }
            g.drawLine(this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
            int estado = this.cuerdas[i2].getEstado();
            if (estado > 0) {
                int color;
                if (i2 < 3 || this.instrumento > 0) {
                    color = 240 - estado * 12;
                    g.setColor(color, color, color);
                } else {
                    color = 160 - estado * 8;
                    g.setColor(color, color, color);
                }
                if (this.cuerdas[i2].getTraste() < this.traste) {
                    g.drawLine(-1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP, -1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                    g.drawLine(1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP, 1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                } else if (this.cuerdas[i2].getTraste() < this.traste + this.numTrastes) {
                    g.drawLine(-1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP + (this.cuerdas[i2].getTraste() - this.traste) * this.lT + this.lT / 2, -1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                    g.drawLine(1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP + (this.cuerdas[i2].getTraste() - this.traste) * this.lT + this.lT / 2, 1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                } else {
                    g.drawLine(-1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP + this.numTrastes * this.lT, -1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                    g.drawLine(1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP + this.numTrastes * this.lT, 1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                }
            }
            switch (this.cuerdas[i2].getTraste()) {
                case -1: {
                    g.drawImage(Imagenes.imgCruz, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP / 2, 3);
                    break;
                }
                case 0: {
                    if (!pintarAros) break;
                    g.drawImage(Imagenes.imgAro, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP / 2, 3);
                    break;
                }
                default: {
                    if (this.cuerdas[i2].getTraste() < this.traste || this.cuerdas[i2].getTraste() >= this.traste + this.numTrastes) break;
                    g.drawImage(Imagenes.imgPunto, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.numBarrasAcordes + this.lP + (this.cuerdas[i2].getTraste() - this.traste) * this.lT + this.lT / 2 - 1, 3);
                }
            }
            ++i2;
        }
        if (cejilla >= this.traste && cejilla < this.traste + this.numTrastes) {
            g.drawImage(Imagenes.imgCejilla[this.zoom], this.margenX + (this.getWidth() - 2 * this.margenX) / 2, this.lB + this.lA * this.numBarrasAcordes + this.lP + (cejilla - this.traste) * this.lT + this.lT / 2 - 1, 3);
        }
    }

    public void update(Graphics g) {
    }

    private Object getControl(int x, int y) {
        if (y < this.lB) {
            if (x > this.getWidth() - this.lB) {
                return "salir";
            }
            if (x > this.getWidth() - this.lB * 2) {
                return "ajustes";
            }
            if (x > this.getWidth() - this.lB * 3) {
                return "zoom";
            }
            if (x > this.getWidth() - this.lB * 4) {
                if (this.limpiarCuerdas()) {
                    return "borrar";
                }
            } else {
                if (x > this.getWidth() - this.lB * 5) {
                    return "grabar";
                }
                if (x > 15 && x < 45) {
                    return "volumen";
                }
            }
        } else if (y < this.lB + this.lA * this.numBarrasAcordes) {
            if (x < this.getWidth()) {
                return "acordes";
            }
        } else if (y < this.lB + this.lA * this.numBarrasAcordes + this.lP) {
            if (x > this.margenX && x < this.getWidth() - this.margenX) {
                return "plastico";
            }
        } else if (y < this.lB + this.lA * this.numBarrasAcordes + this.lP + 5 * this.lT) {
            if (x > this.margenX && x < this.getWidth() - this.margenX) {
                return "trastes";
            }
            if (x > this.getWidth() - this.margenX + 10 - this.zoom * 6 & x < this.getWidth() - this.margenX + 10 - this.zoom * 6 + 22) {
                if (y < this.iO) {
                    return "up";
                }
                if (y < this.iO + this.lO) {
                    return "offset";
                }
                if (y < this.iO + this.lO + 22) {
                    return "down";
                }
            }
        } else {
            return "cuerdas";
        }
        return null;
    }

    protected void pointerPressed(int x, int y) {
        Object control;
        int numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        this.puntos[numPunto].setPos(x, y);
        this.puntos[numPunto].setDireccion(0);
        if (numPunto < 10 && (control = this.getControl(x, y)) != null) {
            if (control.equals("volumen")) {
                this.volumen = 10 - (y - 10) / 5 > 10 ? 10 : 10 - (y - 10) / 5;
                this.repintarBarra = true;
            } else if (control.equals("salir")) {
                this.guitarra.confirmarSalida();
            } else if (control.equals("ajustes")) {
                this.guitarra.ajustes();
            } else if (control.equals("zoom")) {
                this.setZoom(this.zoom == 0 ? 1 : 0);
            } else if (control.equals("borrar")) {
                this.acorde = -1;
                this.setTrastes();
                this.repintarBarra = true;
                this.repintarAcordes = true;
            } else if (control.equals("grabar")) {
                if (this.guitarra.grabarAcorde()) {
                    this.guitarra.editarNombre(1);
                }
            } else if (control.equals("plastico")) {
                int cuerda = (x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX);
                switch (this.cuerdas[cuerda].getTraste()) {
                    case -1: {
                        this.cuerdas[cuerda].setTraste(0);
                        break;
                    }
                    default: {
                        this.cuerdas[cuerda].setTraste(-1);
                    }
                }
                this.acordeModificado = true;
                this.repintarBarra = true;
                this.repintarAcordes = true;
            } else if (control.equals("trastes")) {
                int cuerda = (x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX);
                int traste = this.traste + (y - (this.lB + this.lA * this.numBarrasAcordes + this.lP)) / this.lT;
                if (this.cuerdas[cuerda].getTraste() != traste) {
                    this.cuerdas[cuerda].setTraste(traste);
                } else {
                    this.cuerdas[cuerda].setTraste(0);
                }
                this.acordeModificado = true;
                this.repintarBarra = true;
                this.repintarAcordes = true;
            } else if (control.equals("acordes")) {
                int acorde = (y - this.lB) / this.lA * 6 + x * 6 / this.getWidth();
                if (this.acorde != acorde || this.acordeModificado) {
                    this.acorde = acorde;
                    this.setTrastes();
                    this.acordeModificado = false;
                    this.repintarBarra = true;
                    this.repintarAcordes = true;
                }
            } else if (control.equals("up")) {
                this.setTraste(this.traste - 1);
            } else if (control.equals("down")) {
                this.setTraste(this.traste + 1);
            } else if (control.equals("offset")) {
                this.setTraste(1 + (this.descTrastes.length - this.numTrastes + 1) * (y - this.iO) / this.lO);
            } else if (control.equals("cuerdas")) {
                Cuerda cuerda;
                int i = 0;
                while (i < this.cuerdas.length) {
                    this.cuerdas[i].activada(false);
                    ++i;
                }
                if (!(x <= this.margenX || x >= this.getWidth() - this.margenX || (cuerda = this.cuerdas[(x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX)]).getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                    this.activarCuerda(cuerda);
                }
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        int numPunto;
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            Object control = this.getControl(x, y);
            if (control != null) {
                if (control.equals("volumen")) {
                    this.volumen = 10 - (y - 10) / 5 > 10 ? 10 : 10 - (y - 10) / 5;
                    this.repintarBarra = true;
                } else if (control.equals("offset")) {
                    this.setTraste(1 + (this.descTrastes.length - this.numTrastes + 1) * (y - this.iO) / this.lO);
                } else if (control.equals("cuerdas") && x - this.puntos[numPunto].getX() != 0) {
                    Cuerda cuerda;
                    int pos;
                    int direccion = (x - this.puntos[numPunto].getX()) / Math.abs(x - this.puntos[numPunto].getX());
                    if (this.puntos[numPunto].getDireccion() != 0 && this.puntos[numPunto].getDireccion() != direccion) {
                        int i = 0;
                        while (i < this.cuerdas.length) {
                            pos = this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i + 1) / 12;
                            if (direccion > 0) {
                                if (pos > x) {
                                    this.cuerdas[i].activada(false);
                                }
                            } else if (direccion < 0 && pos < x) {
                                this.cuerdas[i].activada(false);
                            }
                            ++i;
                        }
                        this.puntos[numPunto].setPos0(x, y);
                    }
                    this.puntos[numPunto].setDireccion(direccion);
                    if (!(x <= this.margenX || x >= this.getWidth() - this.margenX || (cuerda = this.cuerdas[(x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX)]).activada() || cuerda.getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                        this.activarCuerda(cuerda);
                    }
                    int i = 0;
                    while (i < this.cuerdas.length) {
                        pos = this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i + 1) / 12;
                        if (direccion > 0) {
                            if (!(pos <= this.puntos[numPunto].getX0() || pos >= x || this.cuerdas[i].activada() || this.cuerdas[i].getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                                this.activarCuerda(this.cuerdas[i]);
                            }
                        } else if (!(direccion >= 0 || pos <= x || pos >= this.puntos[numPunto].getX0() || this.cuerdas[i].activada() || this.cuerdas[i].getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                            this.activarCuerda(this.cuerdas[i]);
                        }
                        ++i;
                    }
                }
            }
            this.puntos[numPunto].setPos(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        int numPunto;
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            this.puntos[numPunto].desactivar();
        }
    }

    protected void sizeChanged(int w, int h) {
        this.repintarBarra = true;
        this.repintarAcordes = true;
    }

    protected void showNotify() {
        this.activo = true;
        try {
            this.p.prefetch();
            this.p.start();
            this.mc = (MIDIControl)this.p.getControl("javax.microedition.media.control.MIDIControl");
            this.mc.setProgram(0, 15488, this.guitarra.getInstrumento(this.instrumento).getInstrumento());
        }
        catch (Exception e) {
            this.guitarra.mostrarError(new Exception(Idioma.texto_error_midi[this.guitarra.getIdioma()]));
        }
        new Thread(this).start();
    }

    protected void hideNotify() {
        this.activo = false;
        this.desactivarCuerdas();
        int i = 0;
        while (i < 10) {
            if (this.puntos[i].activo()) {
                this.puntos[i].desactivar();
            }
            ++i;
        }
        if (this.p.getState() == 400) {
            try {
                this.p.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.p.deallocate();
    }

    public void run() {
        this.repintarBarra = true;
        this.repintarAcordes = true;
        while (this.activo) {
            int i = 0;
            while (i < 10) {
                if (this.puntos[i].activo() && "acordes".equals(this.getControl(this.puntos[i].getX(), this.puntos[i].getY())) && this.puntos[i].getTiempo() > 1000L) {
                    this.acorde = (this.puntos[i].getY() - this.lB) / this.lA * 6 + this.puntos[i].getX() * 6 / this.getWidth();
                    this.guitarra.selAcorde();
                }
                ++i;
            }
            i = 0;
            while (i < this.cuerdas.length) {
                if (this.cuerdas[i].activa()) {
                    if (this.cuerdas[i].getEstado() >= 15) {
                        this.desactivarCuerda(this.cuerdas[i], this.guitarra.getInstrumento(this.instrumento).silenciarNota());
                    } else {
                        this.cuerdas[i].setEstado(this.cuerdas[i].getEstado() + 1);
                    }
                }
                ++i;
            }
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

